hmLoadTopic({
hmKeywords:"",
hmTitle:"Custom EndPoints",
hmDescription:"LinkarWS allows to create custom EndPoints to execute any of the operations defined in the sendcommand function of Linkar Server. ",
hmPrevLink:"ws_entrypoints.html",
hmNextLink:"ws_api-resources.html",
hmParentLink:"ws_manager.html",
hmBreadCrumbs:"<a href=\"ws_manager.html\">LinkarWS Manager<\/a>",
hmTitlePath:"LinkarWS Manager > Custom EndPoints",
hmHeader:"<h1 class=\"p_Heading1\" style=\"page-break-after: avoid;\"><span class=\"f_Heading1\">Custom EndPoints<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">LinkarWS allows to create custom EndPoints to execute any of the operations defined in the <span style=\"font-style: italic;\">sendcommand<\/span> function of Linkar Server. <\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">They can be used to run CRUD requests, TCL\/ECL commands, subroutines, and to format data. &nbsp; <\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">More information at  <span style=\"color: #0000ff; text-decoration: underline;\"><a href=\"https:\/\/kosday.com\/Manuals\/en_WEB_LINKAR_Clients\/lk_sendcommand.html\" target=\"_blank\" class=\"weblink\">https:\/\/kosday.com\/Manuals\/en_WEB_LINKAR_Clients\/lk_sendcommand.html<\/a><\/span><\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">XML and JSON templates are available at https:\/\/github.com\/kosday\/Resources, to copy into the code and modify.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">In this section we will include the necessary parameters to document the EndPoint in the Swagger and to execute the sendcommand function. <\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<div style=\"text-align: center; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><div style=\"margin:0 auto 0 auto;width:80%;max-width:1600px;height:auto;\"><img style=\"width:100%;height:auto;border:none\" src=\".\/images\/endpointslist.png\"\/><\/div><\/div>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<div style=\"text-align: center; text-indent: 0; padding: 0 0 0 0; margin: 0 0 0 0;\"><table class=\"argumentos\" >\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Field<\/span><\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Type<\/span><\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Description<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">New<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Create an EndPoint.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Delete Selected<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Deletes the selected EndPoints from the Database.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Export Selected<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Exports the selected EndPoints to a JSON file.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Import from file<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Import EndPoints from a JSON file.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Pencil Icon<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Edit the EndPoint.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Trash Can Icon<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Delete the EndPoint.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"height:2.6875rem; background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Copy Icon<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"height:2.6875rem; background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"height:2.6875rem; background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Create an EndPoint by copying data from an existing EndPoint.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\" style=\"text-align: center;\">&nbsp;<\/p>\n\r<p class=\"p_HeadingHowTo_atoc_\" style=\"page-break-after: avoid;\"><img style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/tog_plus.gif\"\/><span class=\"f_HeadingHowTo_atoc_\" style=\"font-size: 1.00rem; font-family: Arial,Helvetica,sans-serif;\">Create\/Edit\/Copy EndPoint<\/span><\/p>\n\r<div style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 0 2.0000rem;\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><div class=\"p_Normal\" style=\"text-align: center;\"><div style=\"margin:0 auto 0 auto;width:80%;max-width:1533px;height:auto;\"><img style=\"width:100%;height:auto;border:none\" src=\".\/images\/endpoints1.png\"\/><\/div><\/div>\n\r<div class=\"p_Normal\" style=\"text-align: center;\"><div style=\"margin:0 auto 0 auto;width:80%;max-width:1379px;height:auto;\"><img style=\"width:100%;height:auto;border:none\" src=\".\/images\/endpoints2.png\"\/><\/div><\/div>\n\r<p class=\"p_Normal\" style=\"text-align: center;\">&nbsp;<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<div style=\"text-align: center; text-indent: 0; padding: 0 0 0 0; margin: 0 0 0 0;\"><table class=\"argumentos\" >\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Campo<\/span><\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Tipo<\/span><\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-weight: bold;\">Descripción<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Cancel<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Discard the changes and close the form.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Create\/Update<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">Button<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Save the EndPoint<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Name<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Required<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Name of the EndPoint. Only numbers and letters. Will be used in the url to make the request.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Internal Description<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Internal description for documentation.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">EndPoint Description<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">This description will appear in the Swagger.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Enabled<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Switch<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Switch to enable or disable the EndPoint.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Input Arguments Description<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">We will indicate the meaning of the EndPoint arguments in each row. These comments will appear in the Swagger in documentary form. The label name assigned to each argument will appear in the box on the right, in the form %LKARGn% or %ESCAPED.LKARGn%.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Request Body Description<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">In case of needing to use the Body we will indicate here the description that will be used in the Swagger to document. The label to be used to assign the Body will be %LKBODY% or %ESCAPED.LKBODY%.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Request Body Example<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">We will use this property to document the Swagger with an example of the body.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Output Argument<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">It is a filter that allows to return to the client a part of the answer. If you do not specify anything, the complete result of the request will be returned. <\/p>\n\r<p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">You can use these links to help you compose the expression:<\/p>\n\r<p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">For JSON expressions:  <span style=\"color: #0000ff; text-decoration: underline;\"><a href=\"https:\/\/jsonpath.com\/\" target=\"_blank\" class=\"weblink\">https:\/\/jsonpath.com\/<\/a><\/span><\/p>\n\r<p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">For XML expressions:  <span style=\"color: #0000ff; text-decoration: underline;\"><a href=\"http:\/\/xpather.com\/\" target=\"_blank\" class=\"weblink\">http:\/\/xpather.com\/<\/a><\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Output Argument Description<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"background-color:#CCFFFF;\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">A description of the output argument for documenting in Swagger.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">HTTP status code argument number<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">Optional<\/p>\n\r<\/td>\n\r<td class=\"argumentos\"><p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">It is the argument of the subroutine with the HTTS Error Code to be returned to the client. More info in <a href=\"lk_http-status-code.html\" class=\"topiclink\">HTTP status code<\/a><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">We must choose the template or templates of the sendcommand to be executed in this EndPoint. To do this we first define the type of command JSON or XML, and choose one of the templates available in the combo box. Click the Add Template button and the command structure will be painted in the Commands box.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\">The possible labels to be used within the command are as follows:<\/p>\n\r<p style=\"text-align: justify; text-indent: 0; line-height: 1.28; padding-left: 1.6250rem; margin: 0 0 0.6875rem 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">%LKARGn% and %ESCAPED.LKARGn%<\/span><\/p><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">n is a number from 1 to x. There are as many labels as you have parameters in endpoint.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">. .\/api\/v1\/apidemo\/custom\/subroutine.demo?arg1=2&amp;arg2=aa.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">%LKARG1% will be replaced by the value of arg1, and so on.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">The &quot;ESCAPED&quot; tag is used to replace escaped values.<\/p>\n\r<p style=\"text-align: justify; text-indent: 0; line-height: 1.28; padding-left: 1.6250rem; margin: 0 0 0.6875rem 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">%LKBODY% and %ESCAPED.LKBODY%<\/span><\/p><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">If the endpoint is of the POST type where the input data must be in the Body of the request, we will use this tag to substitute it for the value contained in the Body<\/p>\n\r<p style=\"text-align: justify; text-indent: 0; line-height: 1.28; padding-left: 1.6250rem; margin: 0 0 0.6875rem 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">%LK.OUT:&lt;expression&gt;%<\/span><\/p><p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">This tag when you want to execute chained commands. LinkarWS allows us to execute a sequence of sendcommand type commands within the same custom endpoint. And this tag allows us to pass values from one response to the input of the next command. With an example it will be better understood:<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 4.8750rem;\"><span style=\"background-color: #00ffff;\">..\/api\/v1\/apidemo\/custom\/demo.in.cascade?arg1=2&amp;arg2=11<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">{&nbsp;&quot;NAME&quot;&nbsp;:&nbsp;&quot;READ&quot;,&nbsp;&quot;COMMAND&quot;&nbsp;:<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;{<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;CALCULATED&quot;&nbsp;:&nbsp;&quot;False&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;CONVERSION&quot;&nbsp;:&nbsp;&quot;False&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;FORMAT_SPEC&quot;&nbsp;:&nbsp;&quot;False&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;ORIGINAL_RECORDS&quot;&nbsp;:&nbsp;&quot;False&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;CUSTOM_VARS&quot;&nbsp;:&nbsp;&quot;&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;OUTPUT_FORMAT&quot;&nbsp;:&nbsp;&quot;JSON&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;FILE_NAME&quot;&nbsp;:&nbsp;&quot;LK.CUSTOMERS&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;DICT_CLAUSE&quot;&nbsp;:&nbsp;&quot;&quot;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;RECORDS&quot;&nbsp;:<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&quot;LKITEMID&quot;&nbsp;:&nbsp;<\/span><span class=\"f_CodeExample\" style=\"background-color: #00ffff;\">&quot;%LKARG1%&quot;<\/span><span class=\"f_CodeExample\">&nbsp;}<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;]<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;}<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">},<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">{&nbsp;&quot;NAME&quot;&nbsp;:&nbsp;&quot;SUBROUTINE&quot;,&nbsp;<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&quot;COMMAND&quot;&nbsp;:<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;{<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;SUBROUTINE_NAME&quot;&nbsp;:&nbsp;&quot;SUB.DEMOLINKAR&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;NUMBER_OF_ARGUMENTS&quot;&nbsp;:&nbsp;&quot;3&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;ARGUMENTS&quot;&nbsp;:<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&quot;ARGUMENT&quot;&nbsp;:&nbsp;&quot;0&quot;&nbsp;}&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<\/span><span class=\"f_CodeExample\" style=\"background-color: #00ffff;\">{&nbsp;&quot;ARGUMENT&quot;&nbsp;:&nbsp;&quot;<\/span><span class=\"f_CodeExample\" style=\"font-weight: bold; background-color: #00ffff;\">%LKOUT:COMMAND.RECORDS[0].NAME%<\/span><span class=\"f_CodeExample\" style=\"background-color: #00ffff;\">&nbsp;-&nbsp;%LKARG2%&quot;&nbsp;}&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{&nbsp;&quot;ARGUMENT&quot;&nbsp;:&nbsp;&quot;&quot;&nbsp;}<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;]&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;CUSTOM_VARS&quot;&nbsp;:&nbsp;&quot;&quot;&nbsp;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&quot;OUTPUT_FORMAT&quot;&nbsp;:&nbsp;&quot;JSON&quot;<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;}<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">}<\/span><\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">The first command executes a READ of Register 2 of File LK.CUSTOMERS. <\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\">The second command executes a SUBROUTINE, and one of its input arguments is the expression COMMAND.RECORDS[0].NAME which is extracted from the result of the first command.<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 1.6250rem;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_HeadingHowTo_atoc_\" style=\"page-break-after: avoid;\"><img id=\"TOGGLE0186A1_ICON\" class=\"dropdown-toggle-icon\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/tog_plus.gif\"\/><span class=\"f_HeadingHowTo_atoc_\" style=\"font-size: 1.00rem; font-family: Arial,Helvetica,sans-serif;\"><a id=\"TOGGLE0186A1_LINK\" class=\"dropdown-toggle\" style=\"font-style: normal; font-weight: normal; color: #000000; letter-spacing: -0.0625rem; background-color: transparent; text-decoration: none;\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"TOGGLE0186A1_ICON\" data-src0=\".\/images\/tog_plus.gif\" data-src1=\".\/images\/tog_minus.gif\">Commands and Arguments<\/a><\/span><\/p>\n\r<div id=\"TOGGLE0186A1\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 0 2.0000rem;display:none\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">Through examples we will be able to explain how Custom Endpoints work. Based on the existing sendcommand templates, LinkarWS will receive the request and replace the parameters and\/or body bodies in the template.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In the following example using the url ..\/api\/v1\/apidemo\/custom\/subroutine.demo?arg1=2&amp;arg2=aa the %LKARG1% tag will be replaced by the arg1 parameter and the %LKARG2% by the arg2 parameter. And linkar WS will return to the client the argument 3 of the subroutine<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:79.5625rem;height:45.0000rem;border:none\" src=\".\/images\/ws_sample_custom_endpoint.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:81.0000rem;height:55.0625rem;border:none\" src=\".\/images\/ws_sample_swagger_custom_endpoint.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In the following example the variable information of the request will come in the Body.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:84.0000rem;height:52.3125rem;border:none\" src=\".\/images\/ws_sample_custom_endpoint2.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:70.8750rem;height:57.8750rem;border:none\" src=\".\/images\/ws_sample_swagger_custom_endpoint2.png\"\/><\/p>\n\r<p class=\"p_CodeExample\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<p class=\"p_CodeExample\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">You can view more examples by installing the apidemo configuration from the Dashboard.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_CodeExample\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:34.5000rem;height:42.3125rem;border:none\" src=\".\/images\/hmfile_hash_ea6118db.png\"\/><\/p>\n\r<p class=\"p_CodeExample\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_HeadingHowTo_atoc_\" style=\"page-break-after: avoid;\"><img id=\"TOGGLE0186A2_ICON\" class=\"dropdown-toggle-icon\" style=\"margin:0;width:1.0000rem;height:1.0000rem;border:none\" src=\".\/images\/tog_plus.gif\"\/><span class=\"f_HeadingHowTo_atoc_\" style=\"font-size: 1.00rem; font-family: Arial,Helvetica,sans-serif;\"><a id=\"TOGGLE0186A2_LINK\" class=\"dropdown-toggle\" style=\"font-style: normal; font-weight: normal; color: #000000; letter-spacing: -0.0625rem; background-color: transparent; text-decoration: none;\" href=\"javascript:void(0)\" data-type=\"dropdown\" data-state=\"0\" data-icon=\"TOGGLE0186A2_ICON\" data-src0=\".\/images\/tog_plus.gif\" data-src1=\".\/images\/tog_minus.gif\">Expression for the Output Argument<\/a><\/span><\/p>\n\r<div id=\"TOGGLE0186A2\" class=\"dropdown-toggle-body\" style=\"text-align: left; padding: 0 0 0 0; margin: 0 0 0 2.0000rem;display:none\"><table style=\"border:none; border-spacing:0;\">\n\r<tr>\n\r<td style=\"vertical-align:top; padding:0; border:none\"><p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center;\"><img style=\"margin:0 auto 0 auto;width:65.5625rem;height:13.1875rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments.png\"\/><\/p>\n\r<p class=\"p_Normal\">This property can be used to filter the result that arrives to the client. If no LinkarWS expression is used, it will return the complete result of the request.<\/p>\n\r<p class=\"p_Normal\">The format of the expressions to be used will depend on the OUTPUT_FORMAT parameter in all sendcommand templates.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">&quot;OUTPUT_FORMAT&quot;: &quot;MV&quot;<\/span><\/p><p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The result will come in LkString format. More info at:  <a href=\"https:\/\/kosday.com\/Manuals\/en_WEB_LINKARFRAMEWORKNETLIB\/Lib_LinkarStrings\/html\/LkStrings.htm\" target=\"_blank\" class=\"weblink\">https:\/\/kosday.com\/Manuals\/en_WEB_LINKARFRAMEWORKNETLIB\/Lib_LinkarStrings\/html\/LkStrings.htm<\/a><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The first index of all the matrices used will always be 1.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\"><img style=\"margin:0;width:83.6250rem;height:6.9375rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments_sample_mv2.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">ARGUMENTS will return all the arguments of the subroutine<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">ARGUMENTS[3] will return the third argument to the subroutine<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">ARGUMENTS[0] is not a valid expression because in MV format it must start with 1. LinkarWS will return the complete result of the request.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\"><img style=\"margin:0;width:82.0000rem;height:6.9375rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments_sample_mv.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression TOTAL_RECORDS will return the value &quot;101&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression RECORD[1] will return the value &quot;CUSTOMER 1þADDRESS 1þ444 - 444 - 001&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression RECORD[1]&lt;2&gt; will return the value &quot;ADDRESS 1&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">&quot;OUTPUT_FORMAT&quot;: &quot;JSON&quot;<\/span><\/p><p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The result will be sent to the Client in JSON format. Any JsonPath expression can be used. <\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">A JSONPath expression specifies a path to an element (or a set of elements) in a JSON structure. <\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">You can use JSONPath Online Evaluator to validate your own expressions at  <a href=\"https:\/\/jsonpath.com\/\" target=\"_blank\" class=\"weblink\">https:\/\/jsonpath.com\/<\/a><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The first index of all the matrices used will always be 0.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\"><img style=\"margin:0;width:83.6250rem;height:6.9375rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments_sample_mv2.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression COMMAND.ARGUMENTS[2] dewreturns the value &quot;MY DOWNCASE TEXT&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center; margin: 0 0 0 2.4375rem;\"><img style=\"margin:0 auto 0 auto;width:71.3750rem;height:27.6250rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments_sample_json.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression COMMAND.TOTAL_RECORDS will return the value &quot;101&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression COMMAND.RECORDS[0] returns the json <\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">{<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&quot;LKITEMID&quot;:&nbsp;&quot;1&quot;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&quot;NAME&quot;:&nbsp;&quot;CUSTOMER&nbsp;1&quot;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&quot;ADDR&quot;:&nbsp;&quot;ADDRESS&nbsp;1&quot;,<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&quot;PHONE&quot;:&nbsp;&quot;444&nbsp;-&nbsp;444&nbsp;-&nbsp;001&quot;<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 4.8750rem;\"><span class=\"f_CodeExample\">}<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The expression COMMAND.RECORDS[0].NAME will return the value &quot;CUSTOMER 1&quot;.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 1.6250rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: \'Courier New\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">o<\/span><span style=\"font-weight: bold;\">&quot;OUTPUT_FORMAT&quot;: &quot;XML&quot;<\/span><\/p><p class=\"p_CodeExample\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The result will be sent to the Client in XML format. Any XPath expression can be used. <\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">XPath uses path expressions to select nodes or node-sets in an XML document. These path expressions look very much like the expressions you see when you work with a traditional computer file system.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">You can use XPather to validate your own expressions at <span style=\"text-decoration: underline;\"><a href=\"http:\/\/xpather.com\/\" target=\"_blank\" class=\"weblink\">http:\/\/xpather.com\/<\/a><\/span><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">The first index of all the arrays used will always be 1.<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: center; margin: 0 0 0 2.4375rem;\"><img style=\"margin:0 auto 0 auto;width:82.9375rem;height:9.8750rem;border:none\" src=\".\/images\/ws_expression_for_output_arguments_sample_xml.png\"\/><\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"margin: 0 0 0 2.4375rem;\">\/RESPONSE\/ARGUMENTS\/ARGUMENT[3] will return &lt;RESPONSE&gt;MY DOWNCASE TEXT&lt;\/RESPONSE&gt;<\/p>\n\r<p class=\"p_CodeExample\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<p style=\"text-align: justify; line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r"
})
