hmLoadTopic({
hmKeywords:"",
hmTitle:"UpdatePartial",
hmDescription:"Modifies one or more attributes of one or more file records",
hmPrevLink:"lk_update.html",
hmNextLink:"lk_delete.html",
hmParentLink:"lk_crud-operations.html",
hmBreadCrumbs:"<a href=\"lk_linkarws-operations.html\">LinkarWS Operations<\/a> &gt; <a href=\"lk_crud-operations.html\">CRUD Operations<\/a>",
hmTitlePath:"LinkarWS Operations > CRUD Operations > UpdatePartial",
hmHeader:"<h1 class=\"p_Heading1\" style=\"page-break-after: avoid;\"><span class=\"f_Heading1\">UpdatePartial<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Modifies one or more attributes of one or more file records<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">PATCH<\/span>: api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-style: italic;\">&lt;apiresource&gt;<\/span> ApiResource name. e.g. <span style=\"font-style: italic;\">apidemo<\/span>.<br \/>\n\r<span style=\"font-style: italic;\">&nbsp;<\/span><\/p><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-style: italic;\">&lt;filename&gt;<\/span> Name of the file on which the operation is performed. e.g. <span style=\"font-style: italic;\">LK.CUSTOMERS<\/span><br \/>\n\r<span style=\"font-style: italic;\">e.g. api\/v1\/apidemo\/crud\/LK.CUSTOMERS\/<\/span><\/p><p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic;\">Update_Partial<\/span> operation has 2 more variants: <span style=\"font-style: italic;\">DICTIONARIES<\/span> and <span style=\"font-style: italic;\">SCHEMA<\/span>. The difference between the 3 variants is in how the results are displayed.<\/p>\n\r<p class=\"p_Normal\">Input and output parameters are the same in all 3 variants, and the differences are present only when records have multivalues.<\/p>\n\r<p class=\"p_Normal\">For more information, see <span style=\"font-style: italic;\">Response <\/span>section below.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">PATCH<\/span> (DICTIONARIES mode): api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/dict\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">PATCH<\/span> (SCHEMA mode): api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/sch\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Parameters<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 0 0;\"><table class=\"argumentos\" >\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem;\"><p class=\"p_Normal\">dictionaries<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">List of dictionaries to write, separated by space. &nbsp;You may use the format LKFLDx where x is the attribute number. This parameter is mandatory if the request body has plain\/text format. For other cases, <span style=\"font-style: italic;\">dictionaries<\/span> are inside each record in the <span style=\"font-style: italic;\">RECORDS<\/span> tag.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">optimistic_locking<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">Checks out if the file has not been modified by another user<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem;\"><p class=\"p_Normal\">read_after<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem;\"><p class=\"p_Normal\">boolean<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">Reads the record again and returns it after the update. “calculated”, “dictionaries”, “conversion”, “format_spec” and “original_record” will only be effective if this option is true.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">calculated<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">boolean<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">Return the resulting values from the calculated dictionaries.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem;\"><p class=\"p_Normal\">conversion<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem;\"><p class=\"p_Normal\">boolean<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">Execute the defined conversions in the dictionaries before returning.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">format_spec<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">boolean<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">Execute the defined formats in the dictionaries before returning<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem;\"><p class=\"p_Normal\">original_record<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem;\"><p class=\"p_Normal\">boolean<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">Return a copy of the records in MV format.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">custom_vars<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">This is a free text field to send in the transaction. If not empty, subroutine SUB.LK.MAIN.CONTROL.CUSTOM will be called. Add custom code to that subroutine to define special behaviours for some or all transactions.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:13.9375rem;\"><p class=\"p_Normal\">svr_timeout<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.6250rem;\"><p class=\"p_Normal\">integer<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">This is the maximum time in seconds that the client will wait for a response. Use 0 for no timeout.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span style=\"font-size: 0.91rem; font-style: italic;\">(*) Mandatory<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Request Body<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/json<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:35.4375rem;height:20.0000rem;border:none\" src=\".\/images\/json_requestbody.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">It is not necessary to define ALL attributes, only those to be modified. Attributes not defined will remain with their previous values.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">If <span style=\"font-style: italic;\">optimistic locking<\/span> parameter is activated, <span style=\"font-style: italic;\">ORIGINAL_RECORD<\/span> tag must be included. The content of this tag its always a MV buffer as is, with its attribute, multivalue and subvalue marks. If the content of the MV buffer has invalid JSON characters, like double quotation, they must be escaped.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/xml<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:35.4375rem;height:21.3125rem;border:none\" src=\".\/images\/xml_requestbody.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">It is not necessary to define ALL attributes, only those to be modified. Attributes not defined will remain with their previous values.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In this example we have LK.CUSTOMERS file with dictionaries for its 3 attributes. Thats why the names of the dictionaries are displayed (<span style=\"font-style: italic;\">NAME<\/span>, <span style=\"font-style: italic;\">ADDR<\/span> and <span style=\"font-style: italic;\">PHONE<\/span>), otherwise only <span style=\"font-style: italic;\">LKITEMID<\/span> would be displayed.<\/p>\n\r<p class=\"p_Normal\">To define each attribute, new nodes have to be added with the name <span style=\"font-style: italic;\">LKFLDn<\/span>, where n is the number of the attribute.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">If <span style=\"font-style: italic;\">optimistic locking<\/span> parameter is activated, <span style=\"font-style: italic;\">ORIGINAL_RECORD<\/span> tag must be included. The content of this tag its always a MV buffer as is, with its attribute, multivalue and subvalue marks. If the content of the MV buffer has XML invalid characters, they must be escaped.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">text\/plain<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:30.0000rem;height:10.1875rem;border:none\" src=\".\/images\/text_requestbody2.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In this structure, there are three main blocks separated by the <span style=\"font-style: italic;\">FS<\/span> character (ASCII 28). The first part is the list of records IDs, the second one is the list of records MV buffer and the third one (optional) is the list of original MV buffers of each record.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In case of being more than one element in any of the three lists, they must be separated with each other with the <span style=\"font-style: italic;\">RS<\/span> character (ASCII 30). <\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">The MV buffers are the records as is, with attribute (AM), multivalue (VM) and subvalue (SM) marks.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">The list of original MV buffers of each record is mandatory when the option <span style=\"font-style: italic;\">optimistic_locking<\/span> is activated.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">Important:<\/span> It is not necessary to define ALL attributes, only those to be modified. Attributes not defined will remain with their previous values. Those attributes to be modified must be defined inside dictionaries parameter and their values must be defined in the same order as the dictionaries and separated with the AM attribute mark.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Responses<\/span><\/p>\n\r<p class=\"p_Normal\">There are 3 different ways of displaying the results. In JSON,XML formats and plain text (LkString). However, the response will always be displayed in the same format of the request body sent. This means that if the request body was in JSON format, the results will be displayed in JSON, regardless of the <span style=\"font-style: italic;\">Media Type<\/span> value selected for the response.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">On all kind of responses, an <span style=\"font-style: italic;\">ERROR<\/span> tag will list all possible errors during execution of the operation. This tag includes <span style=\"font-style: italic;\">CODE<\/span> tag with the error codes and <span style=\"font-style: italic;\">MESSAGE<\/span> tag with messages of each error.<\/p>\n\r<p class=\"p_Normal\">In responses of type &quot;text\/plain&quot; (LkString MV), error codes and messages are separated by multivalue marks.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/json<\/span><\/p>\n\r<p class=\"p_Normal\">The image below shows the usual response when the application\/json is selected as <span style=\"font-style: italic;\">Media Type. <\/span>The response can have multiple variants.<\/p>\n\r<p class=\"p_Normal\">For more information, <a href=\"lk_application_json.html\" class=\"topiclink\">click here<\/a>.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:30.0000rem;height:25.8750rem;border:none\" src=\".\/images\/json_response2.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/xml<\/span><\/p>\n\r<p class=\"p_Normal\">The image below shows the usual response when the application\/xml is selected as <span style=\"font-style: italic;\">Media Type. <\/span>The response can have multiple variants.<\/p>\n\r<p class=\"p_Normal\">For more information, <a href=\"lk_application_xml.html\" class=\"topiclink\">click here<\/a>.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:30.0000rem;height:26.8125rem;border:none\" src=\".\/images\/xml_response2.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">text\/plain<\/span><\/p>\n\r<p class=\"p_Normal\">Response is displayed in text format. This response is a chain of characters structured in sections, named <span style=\"font-style: italic;\">LkString<\/span>.For more information about the different tags in this response, <a href=\"lk_text_plain.html\" class=\"topiclink\">click here<\/a>.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:30.0000rem;height:21.5625rem;border:none\" src=\".\/images\/text_response2.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r"
})
