hmLoadTopic({
hmKeywords:"",
hmTitle:"HTTP status code",
hmDescription:"The possibility of returning HTTP status codes has been introduced in Endpoint responses. (HTTP Status Code: https:\/\/en.wikipedia.org\/wiki\/List_of_HTTP_status_codes).",
hmPrevLink:"lk_text_plain.html",
hmNextLink:"lk_system-labels.html",
hmParentLink:"lk_response-types.html",
hmBreadCrumbs:"<a href=\"lk_linkarws-operations.html\">LinkarWS Operations<\/a> &gt; <a href=\"lk_response-types.html\">Response Types and HTTP status code<\/a>",
hmTitlePath:"LinkarWS Operations > Response Types and HTTP status code > HTTP status code",
hmHeader:"<h1 class=\"p_Heading1\" style=\"page-break-after: avoid;\"><span class=\"f_Heading1\">HTTP status code<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">The possibility of returning HTTP status codes has been introduced in Endpoint responses. (HTTP Status Code: <a href=\"https:\/\/en.wikipedia.org\/wiki\/List_of_HTTP_status_codes\" target=\"_blank\" class=\"weblink\">https:\/\/en.wikipedia.org\/wiki\/List_of_HTTP_status_codes<\/a>).<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">The answers are grouped into five classes:<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify; margin: 0 0 0 1.6250rem;\">1xx: Informational - Request received, continuing process<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify; margin: 0 0 0 1.6250rem;\">2xx: Success - The action was successfully received, understood, and accepted<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify; margin: 0 0 0 1.6250rem;\">3xx: Redirection - Further action must be taken in order to complete the request<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify; margin: 0 0 0 1.6250rem;\">4xx: Client Error - The request contains bad syntax or cannot be fulfilled<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify; margin: 0 0 0 1.6250rem;\">5xx: Server Error - The server failed to fulfill an apparently valid request<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">All responses, whether in JSON, XML or LkString format, have a node called ERRORS. If this node has content, it means that an error has occurred and the response is returned with the HTTP status code 400. In other cases the response is returned with the HTTP status code 200.<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">In the case of Subroutine Endpoints, both in their Functions and SendCommand versions, in addition to controlling the content of the ERRORS node, there is the possibility of choosing an argument of the subroutine to be used as an HTTP status code. To do this, in these Endpoints, a parameter “arg_number_httpstatuscode” must be provided in the querystring which tells which argument of the subroutine will be used to get the HTTP status code. This parameter is optional. If an argument number is specified, this value will be validated to be greater than 0 and less than the number of arguments in the subroutine. If not, an HTTP 500 status code will be returned informing of the error. In other cases, if it is a valid HTTP status code, the response with that code will be returned. If it is not a valid HTTP status code, an HTTP status code 500 will be returned informing that it was not a valid code. If you do not indicate anything, the response code 200 will be sent.<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">In the case of Custom Endpoints, at the time of their creation through LinkarWS Manager, there is the possibility of specifying a value in the “Http Status Code Argument Number” property. This value will be used when Subroutine type templates are used in the content of the Custom Endpoint and will represent the position of the subroutine argument in which an HTTP status code can be found. That way if a valid HTTP status code is found in the subroutine response of the indicated argument, this code will be used to return the response.<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">This option is especially useful for returning 400 Error statuses to the client when the request does not comply with the business rules stipulated in the subroutine.<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">Find below an example with the SUB.DEMOLINKAR subroutine<\/p>\n\r<p class=\"p_Normal\" style=\"text-align: justify;\">&nbsp;<\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SUBROUTINE&nbsp;SUB.DEMOLINKAR(SECONDS,DOWN,UPPER,HTTPSTATUSCODE)<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IF&nbsp;NUM(SECONDS)&nbsp;THEN<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SLEEP&nbsp;SECONDS<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;UPPER=OCONV(DOWN,&quot;MCU&quot;)<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;HTTPSTATUSCODE=\'\'<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;END&nbsp;ELSE<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;HTTPSTATUSCODE=400<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;END<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span class=\"f_CodeExample\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;RETURN<\/span><\/p>\n\r<p class=\"p_CodeExample\" style=\"margin: 0 0 0 1.6250rem;\"><span style=\"width:1.3750rem;display:inline-block\">&nbsp;<\/span><span class=\"f_CodeExample\">&nbsp;&nbsp;END<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\">This subroutine will return Error 400 if the first argument is not a number.<\/p>\n\r<p style=\"line-height: 1.28; margin: 0 0 0.6875rem 0;\"><span style=\"font-size: 0.91rem; color: #000000;\">&nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r"
})
