hmLoadTopic({
hmKeywords:"",
hmTitle:"Delete",
hmDescription:"Deletes one or more records of a file.  Important: This action is not available in Swagger. DELETE operation implemented on Linkar Web Services gets the records to delete from...",
hmPrevLink:"lk_updatepartial.html",
hmNextLink:"lk_dictionaries.html",
hmParentLink:"lk_crud-operations.html",
hmBreadCrumbs:"<a href=\"lk_linkarws-operations.html\">LinkarWS Operations<\/a> &gt; <a href=\"lk_crud-operations.html\">CRUD Operations<\/a>",
hmTitlePath:"LinkarWS Operations > CRUD Operations > Delete",
hmHeader:"<h1 class=\"p_Heading1\" style=\"page-break-after: avoid;\"><span class=\"f_Heading1\">Delete<\/span><\/h1>\n\r",
hmBody:"<p class=\"p_Normal\">Deletes one or more records of a file.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">Important<\/span>: This action is not available in Swagger. DELETE operation implemented on Linkar Web Services gets the records to delete from the request body.<\/p>\n\r<p class=\"p_Normal\">Swager does not allow to define the content of the body on operations of type DELETE. However, this is possible with applications like Postman.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">DELETE<\/span>: api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-style: italic;\">&lt;apiresource&gt;<\/span> ApiResource name. e.g. <span style=\"font-style: italic;\">apidemo<\/span>.<br \/>\n\r<span style=\"font-style: italic;\">&nbsp;<\/span><\/p><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-style: italic;\">&lt;filename&gt;<\/span> Name of the file on which the operation is performed. e.g. <span style=\"font-style: italic;\">LK.CUSTOMERS<\/span><br \/>\n\r<span style=\"font-style: italic;\">e.g. api\/v1\/apidemo\/crud\/LK.CUSTOMERS\/<\/span><\/p><p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic;\">Delete<\/span> operation has 2 more variants: <span style=\"font-style: italic;\">DICTIONARIES<\/span> and <span style=\"font-style: italic;\">SCHEMA<\/span>. The difference between the 3 variants is in how the results are displayed.<\/p>\n\r<p class=\"p_Normal\">Input and output parameters are the same in all 3 variants, and the differences are present only when records have multivalues.<\/p>\n\r<p class=\"p_Normal\">For more information, see <span style=\"font-style: italic;\">Response <\/span>section below.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">DELETE<\/span> (DICTIONARIES mode): api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/dict\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\"><span style=\"font-weight: bold;\">DELETE<\/span> (SCHEMA mode): api\/v1\/<span style=\"font-weight: bold;\">&lt;apiresource&gt;<\/span>\/crud\/sch\/<span style=\"font-weight: bold;\">&lt;filename&gt;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Parameters<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<div style=\"text-align: left; text-indent: 0; padding: 0 0 0 0; margin: 0 0 0 0;\"><table class=\"argumentos\" >\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem;\"><p class=\"p_Normal\">recover_id<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">If empty, the record will be deleted. in which case the record will be deleted without the possibility of using techniques to reuse deleted codes.<\/p>\n\r<p class=\"p_Normal\">Or it can contain any of the following values: <\/p>\n\r<p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-weight: bold;\">LINKAR<\/span>. Linkar deleted code recovery will be used. The <span style=\"font-weight: bold;\">prefix<\/span> and <span style=\"font-weight: bold;\">separator<\/span> options can be used. <\/p><p class=\"p_Normal\" style=\"text-indent: 0; padding-left: 0.8125rem; margin-left: 0;\"><span class=\"f_Normal\" style=\"font-family: Arial,\'Lucida Sans Unicode\',\'Lucida Grande\',\'Lucida Sans\';display:inline-block;width:0.8125rem;margin-left:-0.8125rem\">&#8226;<\/span><span style=\"font-weight: bold;\">CUSTOM<\/span>. Customized code recovering.<\/p><\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">prefix<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">The code prefix<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem;\"><p class=\"p_Normal\">separator<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">The separator between the prefix and the code. The allowed separators list is: ! &quot; # \$ % &amp; \' ( ) * + , - . \/ : ; &lt; = &gt; ? @ [ \\ ] ^ _ ` { | } ~<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">optimistic_locking<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">Checks out if the file has not been modified by another user<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem;\"><p class=\"p_Normal\">custom_vars<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem;\"><p class=\"p_Normal\">string<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem;\"><p class=\"p_Normal\">This is a free text field to send in the transaction. If not empty, subroutine SUB.LK.MAIN.CONTROL.CUSTOM will be called. Add custom code to that subroutine to define special behaviours for some or all transactions.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<tr class=\"argumentos\">\n\r<td class=\"argumentos\" style=\"width:14.1250rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">svr_timeout<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:5.5000rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">integer<\/p>\n\r<\/td>\n\r<td class=\"argumentos\" style=\"width:49.3750rem; background-color:#CCFFFF;\"><p class=\"p_Normal\">This is the maximum time in seconds that the client will wait for a response. Use 0 for no timeout.<\/p>\n\r<\/td>\n\r<\/tr>\n\r<\/table>\n\r<\/div>\n\r<p class=\"p_Normal\"><span style=\"font-size: 0.91rem; font-style: italic;\">(*) Mandatory<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Request Body<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/json<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">{ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp;&quot;RECORDS&quot;: [ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp;{ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp;&quot;LKITEMID&quot;: &quot;string&quot;, &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp;&quot;ORIGINAL_RECORD&quot;: &quot;string&quot; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp;} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp;] &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">If <span style=\"font-style: italic;\">optimistic locking<\/span> parameter is activated, <span style=\"font-style: italic;\">ORIGINAL_RECORD<\/span> tag must be included. The content of this tag its always a MV buffer as is, with its attribute, multivalue and subvalue marks. If the content of the MV buffer has invalid JSON characters, like double quotation, they must be escaped.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/xml<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">&lt;LINKAR&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp;&lt;RECORDS&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp; &nbsp;&lt;RECORD&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;LKITEMID&gt;string&lt;\/LKITEMID&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;ORIGINAL_RECORD&gt;string&lt;\/ORIGINAL_RECORD&gt; &nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;\/RECORD&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\"> &nbsp; &nbsp;&lt;\/RECORDS&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/span><\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">&lt;\/LINKAR&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">If <span style=\"font-style: italic;\">optimistic locking<\/span> parameter is activated, <span style=\"font-style: italic;\">ORIGINAL_RECORD<\/span> tag must be included. The content of this tag its always a MV buffer as is, with its attribute, multivalue and subvalue marks. If the content of the MV buffer has XML invalid characters, they must be escaped.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">text\/plain<\/span><\/p>\n\r<p class=\"p_Normal\">The entry record has the following structure:<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span class=\"f_ImageCaption\">recordId_1 + RS + recordId_2 + FS + original_record_1 + RS + original_record_2<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In this structure, there are two main blocks separated by the <span style=\"font-style: italic;\">FS<\/span> character (ASCII 28). The first part is the list of records IDs, the second one is the list of records MV buffer.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">In case of being more than one element in any of the three lists, they must be separated with each other with the <span style=\"font-style: italic;\">RS<\/span> character (ASCII 30). <\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">The MV buffers are the records as is, with attribute (AM), multivalue (VM) and subvalue (SM) marks.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-size: 1.09rem; font-weight: bold;\">Responses<\/span><\/p>\n\r<p class=\"p_Normal\">The response, if no errors occurred, will be a list of deleted record IDs. There is no difference between <span style=\"font-style: italic;\">DICTIONARIES<\/span> and <span style=\"font-style: italic;\">SCHEMA<\/span> variants.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">On all kind of responses, an <span style=\"font-style: italic;\">ERROR<\/span> tag will list all possible errors during execution of the operation. This tag includes <span style=\"font-style: italic;\">CODE<\/span> tag with the error codes and <span style=\"font-style: italic;\">MESSAGE<\/span> tag with messages of each error.<\/p>\n\r<p class=\"p_Normal\">In responses of type &quot;text\/plain&quot; (LkString MV), error codes and messages are separated by multivalue marks.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/json<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">{ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp;&quot;RECORDS&quot;: [ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp;{ &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp; &nbsp;&quot;LKITEMID&quot;: &quot;string&quot; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp;} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp;], &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\"> &nbsp;“ERRORS”: [] &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\">} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">application\/xml<\/span><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\">&lt;LINKAR&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp;&lt;RECORDS&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp; &nbsp; &nbsp;&lt;RECORD&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;LKITEMID&gt;string&lt;\/LKITEMID&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;\/RECORD&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp;&lt;\/RECORDS&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <\/p>\n\r<p class=\"p_Normal\"> &nbsp; &nbsp;&lt;ERRORS&gt;&lt;\/ERRORS&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\">&lt;\/LINKAR&gt; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><span style=\"font-style: italic; font-weight: bold;\">text\/plain<\/span><\/p>\n\r<p class=\"p_Normal\">Response is displayed in text format. This response is a chain of characters structured in sections, named <span style=\"font-style: italic;\">LkString<\/span>. For more information about the different tags in this response, <a href=\"lk_text_plain.html\" class=\"topiclink\">click here<\/a>.<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\"><img style=\"margin:0;width:30.0000rem;height:21.5625rem;border:none\" src=\".\/images\/text_response2.png\"\/><\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r<p class=\"p_Normal\">&nbsp;<\/p>\n\r"
})
